/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFGenHollowTree;

public class TFGenHollowStump
extends TFGenHollowTree {
    public TFGenHollowStump(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(class_5281 world, Random random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        int radius = random.nextInt(2) + 2;
        if (!FeatureUtil.isAreaSuitable(world, pos.method_10069(-radius, 0, -radius), 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, radius, 3, 2, 6, 0.75, 3, 5, 3, false, config);
        this.buildBranchRing(world, trunkPlacer, leavesPlacer, random, pos, radius, 1, 2, 8, 0.9, 3, 5, 3, false, config);
        this.buildTrunk((class_1936)world, trunkPlacer, decorationPlacer, random, pos, radius, 6, config);
        return true;
    }

    @Override
    protected void buildTrunk(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> decoPlacer, Random random, class_2338 pos, int diameter, int maxheight, TFTreeFeatureConfig config) {
        int dz;
        int dx;
        int hollow = diameter >> 1;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    class_2338 dPos = pos.method_10069(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, dPos, config.trunkProvider);
                        continue;
                    }
                    FeaturePlacers.placeIfValidRootPos((class_3746)world, decoPlacer, random, dPos, config.rootsProvider);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = Math.max(ax, az = Math.abs(dz)) + (Math.min(ax, az) >> 1);
                    if (dist > diameter || dist <= hollow) continue;
                    FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10069(dx, dy, dz), config.trunkProvider);
                }
            }
        }
    }
}

